/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.AuthHandler;
import biz.papercut.pcng.client.uit.ClientAccountCache;
import biz.papercut.pcng.client.uit.ClientController;
import biz.papercut.pcng.client.uit.ClientPrintJobHandler;
import biz.papercut.pcng.client.uit.DialogRequestHandler;
import biz.papercut.pcng.client.uit.IdentDialog;
import biz.papercut.pcng.client.uit.Messages;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClient;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.client.uit.UserClientFrame;
import biz.papercut.pcng.common.ClientGlobalConfigFromServer;
import biz.papercut.pcng.util.ApplicationException;
import biz.papercut.pcng.util.concurrent.Runnables;
import biz.papercut.pcng.util.swing.DialogUtils;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.Uninterruptibles;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserClientDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(UserClientDispatcher.class);
    private final UserClientConfig userClientConfig;
    private final UserClientFrame userClientFrame;
    private ClientController clientController;

    UserClientDispatcher(UserClientConfig userClientConfig, UserClientFrame userClientFrame) {
        this.userClientConfig = userClientConfig;
        this.userClientFrame = userClientFrame;
    }

    void startUserClient() throws Exception {
        ServerConnection serverConnection;
        SwingUtilities.invokeAndWait(() -> this.userClientFrame.preConnectionInit(this.userClientConfig));
        try {
            logger.debug("Creating server connection: {}:{}, timeout: {}s", new Object[]{this.userClientConfig.getServerIP(), this.userClientConfig.getServerPort(), this.userClientConfig.getTimeoutSecs()});
            serverConnection = new ServerConnection(this.userClientConfig.getServerName(), this.userClientConfig.getServerIP(), this.userClientConfig.getServerPort(), this.userClientConfig.getTimeoutSecs(), this.userClientConfig.isSilent(), this.userClientConfig.isUseStrictSSLVerification());
        }
        catch (ServerConnection.ServerConnectionException sce) {
            this.userClientFrame.setVisible(false);
            this.userClientFrame.dispose();
            UserClientDispatcher.exitWithError(UserClientDispatcher.format("unable-to-connect", sce.getMessage()), this.userClientConfig.isSilent());
            return;
        }
        UserClientDispatcher.loadServerConfig(this.userClientConfig, this.userClientFrame, serverConnection);
        logger.debug("Config: {}", (Object)this.userClientConfig);
        SwingUtilities.invokeAndWait(() -> this.userClientFrame.completeInitialisation(serverConnection, this.userClientConfig));
        if (!this.userClientConfig.isUsePreAuthentication()) {
            serverConnection.clearAuthentication();
        } else {
            logger.debug("Starting using pre-authentication");
        }
        ClientPrintJobHandler printJobHandler = new ClientPrintJobHandler(this.userClientFrame, serverConnection, this.userClientConfig);
        DialogRequestHandler dialogRequestHandler = new DialogRequestHandler(this.userClientFrame, serverConnection, this.userClientConfig);
        AuthHandler authHandler = new AuthHandler(this.userClientFrame, serverConnection, this.userClientConfig);
        if (this.clientController != null) {
            logger.debug("Replacing client controller that was shutdown: {}", (Object)this.clientController);
        }
        this.clientController = this.createClientController(serverConnection, printJobHandler, dialogRequestHandler, authHandler);
        if (this.userClientConfig.getServerUserConfig().isUnauthenticatedUser() && this.userClientConfig.getServerGlobalConfig().isAuthPopupOnStartupIfUnauthenticated()) {
            Thread.sleep(1000L);
            SwingUtilities.invokeAndWait(authHandler::doAuthRequest);
        }
        this.clientController.start();
    }

    private ClientController createClientController(ServerConnection serverConnection, ClientPrintJobHandler printJobHandler, DialogRequestHandler dialogRequestHandler, AuthHandler authHandler) {
        ClientController clientController = new ClientController(serverConnection, this.userClientConfig, this.userClientFrame);
        clientController.addMessageListener(this.userClientFrame);
        clientController.addBalanceListener(this.userClientFrame);
        clientController.addPrintJobListener(printJobHandler);
        clientController.addDialogRequestListener(dialogRequestHandler);
        clientController.addAuthenticationRequestListener(authHandler);
        return clientController;
    }

    void startWakeupWatcher() {
        Runnables.startInDaemonThread((String)"client-wake-up-watcher", (Runnable)new WakeupWatcher());
    }

    private static void exitWithError(String msg, boolean silent) {
        logger.error("Exiting with error: {}", (Object)msg);
        if (!silent) {
            try {
                SwingUtilities.invokeAndWait(() -> DialogUtils.showErrorMessageDialog(null, (String)"", (String)msg));
            }
            catch (Exception e) {
                logger.error("Exiting with error: {}", (Object)msg);
            }
        }
        System.exit(1);
    }

    private static String format(String key, String ... args) {
        String fullKey = "UserClient." + key;
        return Messages.getString(UserClient.class, fullKey, args);
    }

    private static void loadServerConfig(UserClientConfig conf, UserClientFrame uit, ServerConnection connection) throws Exception {
        connection.setUserName(conf.getUserName());
        conf.setServerGlobalConfig(connection.getGlobalConfig());
        boolean userExists = connection.userExists(conf.getUserName());
        boolean hasShownIdentDialog = false;
        if (conf.isAlwaysRequestIdentity()) {
            logger.debug("Displaying identity dialog - configured to always display");
            UserClientDispatcher.displayIdentDialog(conf, uit, connection);
            hasShownIdentDialog = true;
            userExists = UserClientDispatcher.checkUserExists(conf, connection);
        }
        if (!(hasShownIdentDialog || userExists || conf.isNeverRequestIdentity())) {
            logger.debug("Displaying identity dialog - user does not exist");
            UserClientDispatcher.displayIdentDialog(conf, uit, connection);
            userExists = UserClientDispatcher.checkUserExists(conf, connection);
        }
        if (!userExists) {
            if (!conf.isSilent() && !conf.isSuccessfullyIdentified()) {
                String errorMessage = UserClientDispatcher.format("user-not-found", conf.getUserName());
                uit.setVisible(false);
                uit.dispose();
                UserClientDispatcher.exitWithError(errorMessage, conf.isSilent());
            }
            uit.setTaskTrayToolTip(UserClientDispatcher.format("user-not-found-task-tray", conf.getUserName()));
            int maxRetryDelay = 30;
            int retryDelayIncrement = 3;
            int retryDelay = 2;
            do {
                logger.debug("Retry checking if user exists in: {} secs.", (Object)retryDelay);
                Uninterruptibles.sleepUninterruptibly((long)retryDelay, (TimeUnit)TimeUnit.SECONDS);
                if ((retryDelay += 3) > 30) {
                    retryDelay = 30;
                }
                try {
                    userExists = connection.userExists(conf.getUserName());
                }
                catch (ApplicationException exception) {
                    logger.debug("Failed to determine if the user has been created yet: {}", (Object)exception.getMessage(), (Object)exception);
                }
            } while (!userExists);
        }
        conf.setServerUserConfig(connection.getUserConfig());
        if (conf.isHideBalance()) {
            logger.debug("Hide balance specified on command-line or config file.");
            conf.getServerUserConfig().setShowBalance(false);
        }
        UserClientDispatcher.setupWebPageURLs(conf, connection.getConnectionName());
        ClientAccountCache.initialise(connection, conf);
    }

    private static boolean checkUserExists(UserClientConfig conf, ServerConnection connection) {
        connection.setUserName(conf.getUserName());
        boolean userExists = connection.userExists(conf.getUserName());
        return userExists;
    }

    private static void displayIdentDialog(UserClientConfig conf, UserClientFrame uit, ServerConnection connection) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(() -> {
            IdentDialog d = new IdentDialog(uit, conf, connection);
            d.setVisible(true);
            d.dispose();
        });
    }

    private static void setupWebPageURLs(UserClientConfig conf, String connectionHostName) throws MalformedURLException {
        ClientGlobalConfigFromServer serverConf = conf.getServerGlobalConfig();
        boolean ssl = serverConf.isUseSslInBrowser() && serverConf.getSslPort() > 0;
        String protocol = ssl ? "https" : "http";
        int port = ssl ? serverConf.getSslPort() : conf.getServerPort();
        URL userPageURL = new URL(protocol, connectionHostName, port, serverConf.getUserPagePath());
        URL registerPageURL = new URL(protocol, connectionHostName, port, serverConf.getRegisterPagePath());
        conf.setUserPageURL(userPageURL.toString());
        conf.setRegisterPageURL(registerPageURL.toString());
        conf.setServerUrl(new URL(protocol, connectionHostName, port, "").toString());
    }

    private class WakeupWatcher
    implements Runnable {
        private final long sleep = 10000L;
        private final long error = 500L;

        private WakeupWatcher() {
        }

        @Override
        public void run() {
            logger.debug("Starting client connection watcher, client connection/controller re-launched after {}ms of process inactivity", (Object)10000L);
            while (true) {
                Stopwatch stopwatch = Stopwatch.createStarted();
                Uninterruptibles.sleepUninterruptibly((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS);
                if (stopwatch.elapsed().toMillis() <= 10500L) continue;
                try {
                    logger.info("Wake from sleep detected - starting a new user client connection");
                    UserClientDispatcher.this.clientController.requestShutdown();
                    Thread.sleep(10000L);
                    SwingUtilities.invokeAndWait(UserClientDispatcher.this.userClientFrame::removeAllComponents);
                    UserClientDispatcher.this.startUserClient();
                    continue;
                }
                catch (Exception e) {
                    logger.error("Error starting client: {}", (Object)e.getMessage(), (Object)e);
                    UserClientDispatcher.exitWithError(UserClientDispatcher.format("unexpected-error", new String[]{e.getMessage()}), false);
                    continue;
                }
                break;
            }
        }
    }
}

