/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.common.ClientGlobalConfigFromServer;
import biz.papercut.pcng.util.swing.DialogBannerPanel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import javax.annotation.Nullable;
import javax.swing.ImageIcon;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserClientUtils {
    private static final Logger logger = LoggerFactory.getLogger(UserClientUtils.class);
    private static final String PROP_CLIENT_HOME = "client.home";
    private static final String CUSTOM_IMAGE_NAME = "client-logo.png";
    private static boolean _hasCheckedForCustomImage;
    private static URL _customImageUrl;

    private UserClientUtils() {
    }

    public static String getHomeDirectory() {
        String home = System.getProperty(PROP_CLIENT_HOME);
        if (home != null) {
            File homeDir = new File(home);
            logger.debug("Testing home directory: " + home);
            if (homeDir.exists() && homeDir.isDirectory()) {
                home = homeDir.getAbsolutePath();
            } else {
                logger.warn("Specified client.home does not exist, using current dir.");
                home = new File("").getAbsolutePath();
            }
        }
        if (home == null) {
            logger.debug("client.home null, using current directory as home directory");
            home = new File("").getAbsolutePath();
        }
        logger.debug("Using home directory: " + home);
        return home;
    }

    @Nullable
    public static URL getCustomIconImage() {
        if (!_hasCheckedForCustomImage) {
            logger.debug("Checking for custom icon image");
            UserClientUtils.setCustomIconImage(null);
        }
        return _customImageUrl;
    }

    public static void setCustomIconImage(@Nullable String customLogoUrl) {
        logger.debug("Set custom icon image for : " + customLogoUrl);
        try {
            if (customLogoUrl != null) {
                _customImageUrl = new URL(customLogoUrl);
            } else {
                File f = new File(UserClientUtils.getHomeDirectory(), CUSTOM_IMAGE_NAME);
                if (f.exists()) {
                    _customImageUrl = f.toURI().toURL();
                }
            }
        }
        catch (Exception e) {
            logger.debug("Unable to locate custom icon", (Throwable)e);
        }
        _hasCheckedForCustomImage = true;
    }

    public static DialogBannerPanel getStandardDialogBanner(String title, String description, ClientGlobalConfigFromServer conf) {
        Image scaledImage;
        ImageIcon orig;
        ImageIcon icon = null;
        URL customIcon = UserClientUtils.getCustomIconImage();
        if (customIcon != null) {
            try {
                orig = new ImageIcon(customIcon);
                scaledImage = orig.getImage().getScaledInstance(48, 48, 4);
                icon = new ImageIcon(scaledImage);
            }
            catch (Exception e) {
                logger.debug("Unable to load custom icon: " + e.getMessage());
            }
        }
        if (icon == null) {
            orig = new ImageIcon(UserClientUtils.class.getResource("images/client-icon.png"));
            scaledImage = orig.getImage().getScaledInstance(48, 48, 4);
            icon = new ImageIcon(scaledImage);
        }
        return new DialogBannerPanel(title, description, icon, conf.isShowLink(), conf.getLinkURL(), conf.getLinkText());
    }

    public static ImageIcon createRetinaImageIcon(URL imgURL) {
        if (imgURL != null) {
            return new ScalableIcon(imgURL, 0.5, 0.5);
        }
        logger.debug("Unable to load refresh image");
        return null;
    }

    public static boolean hasRetinaDisplay() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            try {
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice device = env.getDefaultScreenDevice();
                Field field = device.getClass().getDeclaredField("scale");
                if (field != null) {
                    field.setAccessible(true);
                    Object scale = field.get(device);
                    if (scale instanceof Integer && (Integer)scale == 2) {
                        return true;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static class ScalableIcon
    extends ImageIcon {
        private double sx;
        private double sy;

        public ScalableIcon(URL iconUrl, double sx, double sy) {
            super(iconUrl);
            this.sx = sx;
            this.sy = sy;
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.getImageObserver() == null) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.scale(this.sx, this.sy);
                g.drawImage(this.getImage(), x, y, c);
            } else {
                Graphics2D g2d = (Graphics2D)g;
                g2d.scale(this.sx, this.sy);
                g.drawImage(this.getImage(), x, y, this.getImageObserver());
            }
        }
    }
}

