/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.ApplicationEdition;
import biz.papercut.pcng.util.ApplicationException;
import biz.papercut.pcng.util.ApplicationMode;
import biz.papercut.pcng.util.LocaleUtils;
import biz.papercut.pcng.util.PlatformInfo;
import com.github.zafarkhaja.semver.Version;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationInfo {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationInfo.class);
    private static final String KEY_APP_EDITION = "application.edition";
    private static final String KEY_APP_NAME = "application.name";
    private static final String KEY_APP_URL = "application.url";
    private static final String KEY_APP_UPDATE_URL = "application.update-check-url";
    private static final String KEY_APP_UPDATE_CHECK_DAYS = "application.update-check-days";
    private static final String KEY_APP_DASHBOARD_NEWS_URL = "application.dashboard-news-url";
    private static final String KEY_APP_LICENSING_URL = "application.licensing-url";
    private static final String KEY_KNOWLEDGE_BASE_URL = "application.knowledge-base-url";
    private static final String KEY_PRIVACY_STATEMENT_URL = "application.privacy-statement-url";
    private static final String KEY_APP_TOPUP_CARD_NAME = "application.topup-card-name";
    private static final String KEY_VERSION_MAJOR = "version.major";
    private static final String KEY_VERSION_MINOR = "version.minor";
    private static final String KEY_VERSION_PATCH = "version.patch";
    private static final String KEY_VERSION_SUFFIX = "version.suffix";
    private static final String KEY_VERSION_RELEASE_DATES = "version.release-dates";
    private static final String KEY_VERSION_GRACE_PERIOD_START_DATES = "version.grace-period-start-dates";
    private static final String KEY_BUILD_ID = "version.build";
    private static final String KEY_BUILD_DATE = "build.date";
    private static final String KEY_SUPPORT_URL = "support.url";
    private static final String KEY_SUPPORT_EMAIL = "support.email";
    private static final String KEY_PREMIUM_SUPPORT_EMAIL = "premium-support.email";
    private static final String KEY_SUPPORT_VENDOR = "support.vendor";
    private static final String KEY_SUPPORT_NEWS_URL = "support.news-url";
    private static final String KEY_SUPPORT_MANUAL_URL = "support.manual-url";
    private static final String KEY_ERROR_REPORT_URL = "error.report.url";
    private static final String KEY_COPYRIGHT_OWNER = "copyright.owner";
    private static final String KEY_TRANSLATIONS_PARTIAL = "translations.partial";
    private static final String KEY_TRANSLATIONS_COMPLETE = "translations.complete";
    private static final String KEY_MODULES = "modules";
    private static final String KEY_LICENSE_VERSION_GRACE_MONTHS = "license.version.grace-months";
    private static final String KEY_BRAND = "brand";
    private static final String KEY_GOOGLE_APIS_CLIENT_ID = "google-apis.client-id";
    private static final String KEY_GOOGLE_APIS_CLIENT_SECRET = "google-apis.client-secret";
    private static final String INFO_RESOURCE = "/biz/papercut/application.properties";
    private static final String UNRESOLVED_TAG = "@";
    private static final String NEW_LEGAL_NAME = "PaperCut Software Pty Ltd";
    @Nullable
    private static ApplicationInfo _instance;
    private final Properties _props;
    @Nullable
    private String _resellerId;
    private final boolean _developmentMode;
    private final String _cacheParam;
    private final ApplicationMode applicationMode = ApplicationMode.detect();

    private ApplicationInfo() {
        this._developmentMode = this.applicationMode.isDevelopment();
        URL appInfoUrl = this.getClass().getResource(INFO_RESOURCE);
        logger.debug("Loading application resources from: {}", (Object)appInfoUrl);
        try (InputStream in = this.getClass().getResourceAsStream(INFO_RESOURCE);){
            if (in == null) {
                throw new ApplicationException("Cannot find application.properties. Run the common create-application-properties ant task and refresh project.");
            }
            this._props = this.loadApplicationProperties(in);
            if (StringUtils.containsIgnoreCase((String)this._props.getProperty(KEY_COPYRIGHT_OWNER), (String)"papercut software international")) {
                this._props.put(KEY_COPYRIGHT_OWNER, NEW_LEGAL_NAME);
            }
            String applicationName = StringUtils.trimToEmpty((String)this.getApplicationName());
            logger.debug("Loaded {} application properties for: {}", (Object)this._props.size(), (Object)applicationName);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load application.properties", e);
        }
        this._cacheParam = this._developmentMode ? String.valueOf(System.currentTimeMillis()) : this.getBuildID() + this.getApplicationBrand();
    }

    private Properties loadApplicationProperties(InputStream in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        if (this._developmentMode) {
            this.resolveDevelopmentVersionInfo(props);
        }
        return props;
    }

    public static synchronized ApplicationInfo getInstance() {
        if (_instance == null) {
            _instance = new ApplicationInfo();
        }
        return _instance;
    }

    private void resolveDevelopmentVersionInfo(Properties inProperties) throws IOException {
        this.resolveApplicationProperties(inProperties);
        inProperties.compute(KEY_BUILD_ID, (BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(k, v) -> StringUtils.startsWith((String)String.valueOf(v), (String)UNRESOLVED_TAG) ? "0" : v));
        inProperties.setProperty(KEY_BUILD_DATE, LocalDate.now().format(DateTimeFormatter.ofPattern("MMM dd, yyyy")));
    }

    private void resolveApplicationProperties(Properties applicationProperties) throws IOException {
        Properties brandProperties = this.applicationMode.getBrandProperties();
        applicationProperties.stringPropertyNames().forEach(propName -> {
            String tokenValue;
            String token;
            String propValue = applicationProperties.getProperty((String)propName);
            if (propValue != null && (token = StringUtils.substringBetween((String)propValue, (String)UNRESOLVED_TAG)) != null && (tokenValue = brandProperties.getProperty(token)) != null) {
                applicationProperties.setProperty((String)propName, tokenValue);
            }
        });
    }

    @Nullable
    public synchronized String getResellerId() {
        return this._resellerId;
    }

    public synchronized void setResellerId(String resellerId) {
        this._resellerId = resellerId;
    }

    public ApplicationEdition getApplicationEdition() {
        ApplicationEdition edition = null;
        String editionValue = this._props.getProperty(KEY_APP_EDITION);
        try {
            edition = ApplicationEdition.valueOf(editionValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (edition == null) {
            logger.error("Unable to determine application edition, assuming NG. Value: {}", (Object)editionValue);
            edition = ApplicationEdition.NG;
        }
        return edition;
    }

    public boolean isPaperCutBrand() {
        return true;
    }

    public String getApplicationBrand() {
        return this._props.getProperty(KEY_BRAND);
    }

    public String getApplicationName() {
        return this._props.getProperty(KEY_APP_NAME);
    }

    public String getApplicationURL() {
        return this._props.getProperty(KEY_APP_URL);
    }

    public String getUpdateCheckURL() {
        return this._props.getProperty(KEY_APP_UPDATE_URL);
    }

    public String getPrivacyStatementURL() {
        return this._props.getProperty(KEY_PRIVACY_STATEMENT_URL);
    }

    public String getLicensingURL() {
        return this.findResellerSpecificProperty(KEY_APP_LICENSING_URL);
    }

    public String getTopupCardName() {
        return this._props.getProperty(KEY_APP_TOPUP_CARD_NAME);
    }

    public int getMajorVersion() {
        return this.getIntProperty(KEY_VERSION_MAJOR);
    }

    public int getMinorVersion() {
        return this.getIntProperty(KEY_VERSION_MINOR);
    }

    public int getPatchVersion() {
        return this.getIntProperty(KEY_VERSION_PATCH);
    }

    public String getPreReleaseVersion() {
        String prerelease = this._props.getProperty(KEY_VERSION_SUFFIX, "");
        return StringUtils.removeStart((String)prerelease, (String)"-");
    }

    private String getReleaseDatesString() {
        return this._props.getProperty(KEY_VERSION_RELEASE_DATES, "");
    }

    private String getReleaseUpgradeGracePeriodStartDatesString() {
        return this._props.getProperty(KEY_VERSION_GRACE_PERIOD_START_DATES, "");
    }

    public Map<Integer, Date> getReleaseDates() {
        String s = this.getReleaseDatesString();
        return this.parseVersionDates(s);
    }

    public Map<Integer, Date> getReleaseUpgradeGracePeriodStartDates() {
        String s = this.getReleaseUpgradeGracePeriodStartDatesString();
        return this.parseVersionDates(s);
    }

    private Map<Integer, Date> parseVersionDates(String verDatesStr) {
        String[] releases;
        HashMap<Integer, Date> m = new HashMap<Integer, Date>();
        if (StringUtils.isBlank((String)verDatesStr)) {
            return m;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        for (String release : releases = verDatesStr.split("\\s*,\\s*")) {
            Date releaseDate;
            int version;
            String[] parts = release.split("\\s*:\\s*");
            if (parts.length != 2) {
                logger.error("Unexpected version release date format.");
                continue;
            }
            try {
                version = Integer.parseInt(parts[0]);
            }
            catch (NumberFormatException e) {
                logger.error("Invalid version number in version release dates: " + parts[0]);
                continue;
            }
            try {
                releaseDate = dateFormat.parse(parts[1]);
            }
            catch (ParseException e) {
                logger.error("Invalid date in version release dates: " + parts[1]);
                continue;
            }
            m.put(version, releaseDate);
        }
        return m;
    }

    public int getLicenseVersionGraceMonths() {
        int months = 0;
        try {
            months = Integer.parseInt(this._props.getProperty(KEY_LICENSE_VERSION_GRACE_MONTHS, ""));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return months;
    }

    public int getUpdateCheckDays() {
        int days;
        try {
            days = Integer.parseInt(this._props.getProperty(KEY_APP_UPDATE_CHECK_DAYS, ""));
        }
        catch (NumberFormatException e) {
            days = 90;
        }
        return days;
    }

    public String getBuildID() {
        String v = this._props.getProperty(KEY_BUILD_ID);
        if (StringUtils.isBlank((String)v)) {
            v = "unknown";
        }
        return v;
    }

    public String getCacheSerial() {
        return this._cacheParam;
    }

    public String getBuildDateString() {
        String v = this._props.getProperty(KEY_BUILD_DATE);
        if (StringUtils.isBlank((String)v)) {
            v = "?";
        }
        return v;
    }

    public Date getBuildDate() {
        String dateStr = this.getBuildDateString();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        try {
            return dateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public String getErrorReportURL() {
        return this._props.getProperty(KEY_ERROR_REPORT_URL);
    }

    public String getSupportURL() {
        return this.findResellerSpecificProperty(KEY_SUPPORT_URL);
    }

    public String getKnowledgeBaseURL() {
        return this.findResellerSpecificProperty(KEY_KNOWLEDGE_BASE_URL);
    }

    public String getSupportEmail() {
        return this.findResellerSpecificProperty(KEY_SUPPORT_EMAIL);
    }

    public String getPremiumSupportEmail() {
        return this.findResellerSpecificProperty(KEY_PREMIUM_SUPPORT_EMAIL);
    }

    public String getSupportVendor() {
        return this.findResellerSpecificProperty(KEY_SUPPORT_VENDOR);
    }

    public String getSupportNewsURL() {
        return this.findResellerSpecificProperty(KEY_SUPPORT_NEWS_URL);
    }

    public String getDashboardNewsURL() {
        return this.findResellerSpecificProperty(KEY_APP_DASHBOARD_NEWS_URL);
    }

    public String getSupportManualURL(Locale locale) {
        return this.findResellerSpecificProperty(KEY_SUPPORT_MANUAL_URL, locale);
    }

    public String getCopyrightOwner() {
        return this._props.getProperty(KEY_COPYRIGHT_OWNER);
    }

    public String getModulesAvailableString() {
        return this._props.getProperty(KEY_MODULES);
    }

    @Nullable
    public String getGoogleApisClientId() {
        return this._props.getProperty(KEY_GOOGLE_APIS_CLIENT_ID);
    }

    @Nullable
    public String getGoogleApisClientSecret() {
        return this._props.getProperty(KEY_GOOGLE_APIS_CLIENT_SECRET);
    }

    private String findResellerSpecificProperty(String key) {
        return this.findResellerSpecificProperty(key, Locale.getDefault());
    }

    private String findResellerSpecificProperty(String key, Locale locale) {
        String countryCode;
        String value;
        if (StringUtils.isNotBlank((String)this.getResellerId()) && !this.isBlankPropertyValue(value = this._props.getProperty(key + "." + this.getResellerId()))) {
            return value;
        }
        String langCode = locale.getLanguage();
        String value2 = this._props.getProperty(key + "." + langCode + "_" + (countryCode = locale.getCountry()));
        if (!this.isBlankPropertyValue(value2)) {
            return value2;
        }
        value2 = this._props.getProperty(key + "." + langCode);
        if (!this.isBlankPropertyValue(value2)) {
            return value2;
        }
        value2 = this._props.getProperty(key);
        if (this.isBlankPropertyValue(value2)) {
            return "";
        }
        return value2;
    }

    private boolean isBlankPropertyValue(String value) {
        if (StringUtils.isBlank((String)value)) {
            return true;
        }
        return value.startsWith(UNRESOLVED_TAG) && value.endsWith(UNRESOLVED_TAG);
    }

    public String getVersion() {
        return this.getVersionObject(false).toString();
    }

    public String getVersionWithBuildMetadata() {
        return this.getVersionObject(true).toString();
    }

    public Version getVersionObject(boolean includeBuildMetadata) {
        String preReleaseVersion = this.getPreReleaseVersion();
        Version version = Version.forIntegers((int)this.getMajorVersion(), (int)this.getMinorVersion(), (int)this.getPatchVersion());
        if (StringUtils.isNotBlank((String)preReleaseVersion)) {
            version = version.setPreReleaseVersion(preReleaseVersion);
        }
        if (includeBuildMetadata) {
            version = version.setBuildMetadata(this.getBuildID());
        }
        return version;
    }

    public String getDisplayVersion() {
        return this.buildDisplayVersion(false);
    }

    public String getDisplayVersionWithBuildDate() {
        return this.buildDisplayVersion(true);
    }

    public String getDisplayVersionWithPlatformInfo() {
        String fullVersion = this.buildDisplayVersion(false);
        StringBuilder sb = new StringBuilder(100);
        sb.append(fullVersion);
        if (this.isPaperCutBrand()) {
            sb.append(", Edition: ").append((Object)this.getApplicationEdition());
        }
        PlatformInfo pi = PlatformInfo.getPlatformInfo();
        sb.append(", Platform: ").append(pi);
        sb.append(", User: ").append(this.getUsername());
        return sb.toString();
    }

    private String buildDisplayVersion(boolean includeBuildDate) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getVersion());
        sb.append(" (Build ").append(this.getBuildID());
        if (includeBuildDate) {
            sb.append(' ').append(this.getBuildDateString());
        }
        sb.append(")");
        return sb.toString();
    }

    public List<Locale> getCompleteTranslations() {
        ArrayList<Locale> l = new ArrayList<Locale>();
        l.add(Locale.ENGLISH);
        String s = this._props.getProperty(KEY_TRANSLATIONS_COMPLETE);
        l.addAll(LocaleUtils.getLocaleListFromString(s));
        return l;
    }

    public List<Locale> getPartialTranslations() {
        String s = this._props.getProperty(KEY_TRANSLATIONS_PARTIAL);
        return LocaleUtils.getLocaleListFromString(s);
    }

    private String getUsername() {
        if (SystemUtils.IS_OS_WINDOWS) {
            try {
                Class<?> advapi32Class = Class.forName("com.sun.jna.platform.win32.Advapi32");
                Class<?> intByRefClass = Class.forName("com.sun.jna.ptr.IntByReference");
                Field instanceField = advapi32Class.getField("INSTANCE");
                Method getUserNameW = advapi32Class.getMethod("GetUserNameW", char[].class, intByRefClass);
                Constructor<?> intConstructor = intByRefClass.getConstructor(Integer.TYPE);
                Method getValue = intByRefClass.getMethod("getValue", new Class[0]);
                char[] userName = new char[255];
                Object userNameLen = intConstructor.newInstance(userName.length);
                Object advapi32Instance = instanceField.get(null);
                if (((Boolean)getUserNameW.invoke(advapi32Instance, userName, userNameLen)).booleanValue()) {
                    int length = (Integer)getValue.invoke(userNameLen, new Object[0]);
                    return new String(userName, 0, length - 1);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return System.getProperty("user.name");
    }

    private int getIntProperty(String keyName) {
        try {
            return Integer.parseInt(this._props.getProperty(keyName));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public boolean isDevelopmentMode() {
        return this._developmentMode;
    }
}

