/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.io.IOUtils;
import biz.papercut.pcng.util.io.LineHandler;
import biz.papercut.pcng.util.io.NullOutputStream;
import biz.papercut.pcng.util.io.StringBufferLineHandler;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProcessUtils.class);

    private ProcessUtils() {
    }

    public static int exec(String[] cmdArray) throws IOException, InterruptedException {
        return ProcessUtils.exec(cmdArray, (InputStream)null, null, null);
    }

    public static int exec(String[] cmdArray, @Nullable InputStream stdin, @Nullable OutputStream stdout, @Nullable OutputStream stderr) throws IOException, InterruptedException {
        NullOutputStream devNull;
        NullOutputStream nullOutputStream = devNull = stdout == null || stderr == null ? new NullOutputStream() : null;
        if (stdout == null) {
            stdout = devNull;
        }
        if (stderr == null) {
            stderr = devNull;
        }
        return ProcessUtils.exec(cmdArray, new DefaultStreamHandler(stdin, stdout, stderr));
    }

    public static int exec(String[] cmdArray, ProcessStreamHandler streamHandler) throws IOException, InterruptedException {
        return ProcessUtils.exec(cmdArray, streamHandler, null);
    }

    public static int exec(String[] cmdArray, ProcessStreamHandler streamHandler, @Nullable String[] env) throws IOException, InterruptedException {
        return ProcessUtils.exec(cmdArray, streamHandler, env, null);
    }

    public static int exec(String[] cmdArray, ProcessStreamHandler streamHandler, @Nullable String[] env, @Nullable boolean[] hideArgsInLogs) throws IOException, InterruptedException {
        long start = System.currentTimeMillis();
        Process proc = ProcessUtils.execProcess(cmdArray, streamHandler, env, hideArgsInLogs);
        int exitCode = proc.waitFor();
        long stop = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("Exit code is {} and took {} ms running: {}", new Object[]{exitCode, stop - start, cmdArray[0]});
        }
        streamHandler.stop();
        return exitCode;
    }

    public static int exec(String[] cmdArray, @Nullable boolean[] hideArgsInLogs, ProcessStreamHandler streamHandler, @Nullable String[] env, int timeOutSec) throws IOException, InterruptedException, TimeoutException {
        long start = System.currentTimeMillis();
        Process proc = ProcessUtils.execProcess(cmdArray, streamHandler, env, hideArgsInLogs);
        int exitCode = -1;
        if (!proc.waitFor(timeOutSec, TimeUnit.SECONDS)) {
            logger.debug("Timeout exceeded executing {}", (Object)cmdArray[0]);
            proc.destroy();
            throw new TimeoutException("Timeout exceeded executing " + cmdArray[0]);
        }
        exitCode = proc.exitValue();
        long stop = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("Exit code for '{}' is: {}. Took {} ms.", new Object[]{cmdArray[0], exitCode, stop - start});
        }
        streamHandler.stop();
        return exitCode;
    }

    public static int execAndGetOutput(String[] cmdArray, StringBuffer stdout, StringBuffer stderr) throws IOException, InterruptedException {
        StringBufferLineHandler stdoutHandler = new StringBufferLineHandler(stdout);
        StringBufferLineHandler stderrHandler = new StringBufferLineHandler(stderr);
        return ProcessUtils.exec(cmdArray, new LineStreamHandler(null, stdoutHandler, stderrHandler, StandardCharsets.UTF_8));
    }

    public static int execAndGetOutput(String[] cmdArray, @Nullable boolean[] hideArgsInLogs, StringBuffer stdout, StringBuffer stderr, int timeOutSecs) throws IOException, InterruptedException, TimeoutException {
        StringBufferLineHandler stdoutHandler = new StringBufferLineHandler(stdout);
        StringBufferLineHandler stderrHandler = new StringBufferLineHandler(stderr);
        return ProcessUtils.exec(cmdArray, hideArgsInLogs, new LineStreamHandler(null, stdoutHandler, stderrHandler, StandardCharsets.UTF_8), null, timeOutSecs);
    }

    private static Process execProcess(String[] cmdArray, ProcessStreamHandler streamHandler, @Nullable String[] env, @Nullable boolean[] hideArgsInLogs) throws IOException {
        Preconditions.checkArgument((boolean)ArrayUtils.isNotEmpty((Object[])cmdArray), (Object)"Exec command array is null or empty.");
        Preconditions.checkNotNull((Object)streamHandler, (Object)"Null stream handler");
        if (logger.isDebugEnabled()) {
            Object[] debugCmdArray;
            if (hideArgsInLogs != null && hideArgsInLogs.length > 0) {
                debugCmdArray = (String[])cmdArray.clone();
                for (int i = 0; i < hideArgsInLogs.length; ++i) {
                    if (!hideArgsInLogs[i]) continue;
                    debugCmdArray[i] = "<hidden>";
                }
            } else {
                debugCmdArray = cmdArray;
            }
            logger.debug("Execute: {}", (Object)StringUtils.join((Object[])debugCmdArray, (char)' '));
        }
        Process proc = Runtime.getRuntime().exec(cmdArray, env);
        streamHandler.setProcessInputStream(proc.getOutputStream());
        streamHandler.setProcessErrorStream(proc.getErrorStream());
        streamHandler.setProcessOutputStream(proc.getInputStream());
        streamHandler.start();
        return proc;
    }

    public static String quoteArgument(@Nullable String argument) {
        if (argument == null || argument.length() == 0) {
            return "\"\"";
        }
        return "\"" + argument + "\"";
    }

    public static interface ProcessStreamHandler {
        public void setProcessInputStream(OutputStream var1) throws IOException;

        public void setProcessErrorStream(InputStream var1) throws IOException;

        public void setProcessOutputStream(InputStream var1) throws IOException;

        public void start();

        public void stop();
    }

    public static class LineStreamHandler
    extends AbstractStreamHandler {
        @Nullable
        private final Reader _stdin;
        private final LineHandler _stdout;
        private final LineHandler _stderr;
        private final Charset _charset;

        public LineStreamHandler(@Nullable Reader stdin, LineHandler stdout, LineHandler stderr, Charset charset) {
            this._stdin = stdin;
            this._stdout = stdout;
            this._stderr = stderr;
            this._charset = charset;
        }

        public LineStreamHandler(@Nullable Reader stdin, LineHandler stdout, LineHandler stderr) {
            this(stdin, stdout, stderr, Charset.defaultCharset());
        }

        @Override
        public void setProcessInputStream(OutputStream os) {
            if (this._stdin != null) {
                this.setStdinThread(this.createReaderPump(this._stdin, new OutputStreamWriter(os, this._charset), true));
            }
        }

        @Override
        public void setProcessErrorStream(InputStream is) {
            this.setStderrThread(this.createLinePump(new InputStreamReader(is, this._charset), this._stderr, Thread.currentThread().getName() + " stderr"));
        }

        @Override
        public void setProcessOutputStream(InputStream is) {
            this.setStdoutThread(this.createLinePump(new InputStreamReader(is, this._charset), this._stdout, Thread.currentThread().getName() + " stdout"));
        }

        Thread createLinePump(Reader inputReader, LineHandler output, String pumpThreadName) {
            Thread thread = new Thread(() -> {
                try (BufferedReader reader = new BufferedReader(inputReader);){
                    IOUtils.copyLines(reader, output);
                }
                catch (IOException e) {
                    logger.debug("Ignored error", (Throwable)e);
                }
            }, pumpThreadName);
            thread.setDaemon(true);
            return thread;
        }

        Thread createReaderPump(Reader input, Writer output, boolean closeWhenExhausted) {
            Thread thread = new Thread(() -> {
                try (Reader reader = input;){
                    IOUtils.copy(input, output, closeWhenExhausted);
                }
                catch (IOException e) {
                    logger.debug("Ignored error", (Throwable)e);
                }
            }, Thread.currentThread().getName() + " stdin");
            thread.setDaemon(true);
            return thread;
        }

        @Override
        public void stop() {
            super.stop();
            IOUtils.closeQuietly(this._stdin);
        }
    }

    public static class DefaultStreamHandler
    extends AbstractStreamHandler {
        @Nullable
        private final InputStream _stdin;
        private final OutputStream _stdout;
        private final OutputStream _stderr;

        DefaultStreamHandler(@Nullable InputStream stdin, OutputStream stdout, OutputStream stderr) {
            this._stdin = stdin;
            this._stdout = stdout;
            this._stderr = stderr;
        }

        @Override
        public void setProcessInputStream(OutputStream os) {
            if (this._stdin != null) {
                this.setStdinThread(this.createStreamPump(this._stdin, os, true, Thread.currentThread().getName() + " stdin"));
            } else {
                IOUtils.closeQuietly(os);
            }
        }

        @Override
        public void setProcessErrorStream(InputStream is) {
            this.setStderrThread(this.createStreamPump(is, this._stderr, false, Thread.currentThread().getName() + " stderr"));
        }

        @Override
        public void setProcessOutputStream(InputStream is) {
            this.setStdoutThread(this.createStreamPump(is, this._stdout, false, Thread.currentThread().getName() + " stdout"));
        }

        Thread createStreamPump(InputStream is, OutputStream os, boolean closeWhenExhausted, String pumpThreadName) {
            Thread thread = new Thread(() -> {
                try (InputStream inputStream = is;){
                    IOUtils.copy(is, os, closeWhenExhausted);
                }
                catch (IOException e) {
                    logger.debug("Ignored error", (Throwable)e);
                }
            }, pumpThreadName);
            thread.setDaemon(true);
            return thread;
        }

        @Override
        public void stop() {
            super.stop();
            IOUtils.closeQuietly(this._stdin);
            IOUtils.closeQuietly(this._stdout);
            IOUtils.closeQuietly(this._stderr);
        }
    }

    public static abstract class AbstractStreamHandler
    implements ProcessStreamHandler {
        @Nullable
        private Thread _stdoutThread;
        @Nullable
        private Thread _stderrThread;
        @Nullable
        private Thread _stdinThread;

        @Override
        public void start() {
            if (this._stdinThread != null) {
                this._stdinThread.start();
            }
            if (this._stdoutThread != null) {
                this._stdoutThread.start();
            }
            if (this._stderrThread != null) {
                this._stderrThread.start();
            }
        }

        @Override
        public void stop() {
            if (this._stdinThread != null) {
                try {
                    this._stdinThread.join();
                }
                catch (InterruptedException e) {
                    logger.debug("Ignored error", (Throwable)e);
                }
            }
            if (this._stdoutThread != null) {
                try {
                    this._stdoutThread.join();
                }
                catch (InterruptedException e) {
                    logger.debug("Ignored error", (Throwable)e);
                }
            }
            if (this._stderrThread != null) {
                try {
                    this._stderrThread.join();
                }
                catch (InterruptedException e) {
                    logger.debug("Ignored error", (Throwable)e);
                }
            }
        }

        void setStderrThread(Thread stderrThread) {
            this._stderrThread = stderrThread;
        }

        void setStdinThread(Thread stdinThread) {
            this._stdinThread = stdinThread;
        }

        void setStdoutThread(Thread stdoutThread) {
            this._stdoutThread = stdoutThread;
        }
    }
}

