/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public final class SecureXmlProcessing {
    private static final Logger logger = LoggerFactory.getLogger(SecureXmlProcessing.class);

    public static DocumentBuilderFactory documentBuilderFactory(boolean allowDocType, boolean accessExternalDtd, boolean accessExternalSchema, boolean allowExternalEntities) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            if (!allowDocType) {
                dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            if (!accessExternalDtd) {
                dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            }
            if (!accessExternalSchema) {
                dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            }
            if (!allowExternalEntities) {
                dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                dbf.setExpandEntityReferences(false);
            }
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return dbf;
    }

    public static DocumentBuilderFactory documentBuilderFactory() {
        return SecureXmlProcessing.documentBuilderFactory(false, false, false, false);
    }

    public static SAXParserFactory saxParserFactory(boolean allowDocType, boolean allowExternalEntities, boolean accessExternalDtd) {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        try {
            parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            if (!allowDocType) {
                parserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            if (!accessExternalDtd) {
                parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            if (!allowExternalEntities) {
                parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return parserFactory;
    }

    public static SAXParserFactory saxParserFactory() {
        return SecureXmlProcessing.saxParserFactory(false, false, false);
    }

    public static XMLReader xmlReader(boolean allowDocType, boolean accessExternalDtd, boolean allowExternalEntities) {
        XMLReader reader = null;
        try {
            reader = SecureXmlProcessing.saxParserFactory(false, false, false).newSAXParser().getXMLReader();
            if (!allowDocType) {
                reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            if (!accessExternalDtd) {
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            if (!allowExternalEntities) {
                reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        return reader;
    }

    public static XMLInputFactory xmlInputFactory(boolean allowExternalEntities) {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", allowExternalEntities);
        factory.setProperty("javax.xml.stream.supportDTD", false);
        return factory;
    }

    public static XMLInputFactory xmlInputFactory() {
        return SecureXmlProcessing.xmlInputFactory(false);
    }
}

